/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.XMLChar;

public class XML11Char {
    private static final byte[] XML11CHARS;
    public static final int MASK_XML11_VALID = 1;
    public static final int MASK_XML11_SPACE = 2;
    public static final int MASK_XML11_NAME_START = 4;
    public static final int MASK_XML11_NAME = 8;
    public static final int MASK_XML11_CONTROL = 16;
    public static final int MASK_XML11_CONTENT = 32;
    public static final int MASK_XML11_NCNAME_START = 64;
    public static final int MASK_XML11_NCNAME = 128;
    public static final int MASK_XML11_CONTENT_INTERNAL = 48;

    public static boolean isXML11Space(int n) {
        return n < 65536 && (XML11CHARS[n] & 2) != 0;
    }

    public static boolean isXML11Valid(int n) {
        return n < 65536 && (XML11CHARS[n] & 1) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11Invalid(int n) {
        return !XML11Char.isXML11Valid(n);
    }

    public static boolean isXML11ValidLiteral(int n) {
        return n < 65536 && (XML11CHARS[n] & 1) != 0 && (XML11CHARS[n] & 0x10) == 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11Content(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x20) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11InternalEntityContent(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x30) != 0 || 65536 <= n && n <= 0x10FFFF;
    }

    public static boolean isXML11NameStart(int n) {
        return n < 65536 && (XML11CHARS[n] & 4) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11Name(int n) {
        return n < 65536 && (XML11CHARS[n] & 8) != 0 || n >= 65536 && n < 983040;
    }

    public static boolean isXML11NCNameStart(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x40) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11NCName(int n) {
        return n < 65536 && (XML11CHARS[n] & 0x80) != 0 || 65536 <= n && n < 983040;
    }

    public static boolean isXML11NameHighSurrogate(int n) {
        return 55296 <= n && n <= 56191;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static boolean isXML11ValidName(String string) {
        char c;
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 1;
        char c2 = string.charAt(0);
        if (!XML11Char.isXML11NameStart(c2)) {
            if (n <= 1) return false;
            if (!XML11Char.isXML11NameHighSurrogate(c2)) return false;
            c = string.charAt(1);
            if (!XMLChar.isLowSurrogate(c)) return false;
            if (!XML11Char.isXML11NameStart(XMLChar.supplemental(c2, c))) {
                return false;
            }
            n2 = 2;
        }
        while (n2 < n) {
            c2 = string.charAt(n2);
            if (!XML11Char.isXML11Name(c2)) {
                if (++n2 >= n) return false;
                if (!XML11Char.isXML11NameHighSurrogate(c2)) return false;
                c = string.charAt(n2);
                if (!XMLChar.isLowSurrogate(c)) return false;
                if (!XML11Char.isXML11Name(XMLChar.supplemental(c2, c))) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static boolean isXML11ValidNCName(String string) {
        char c;
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 1;
        char c2 = string.charAt(0);
        if (!XML11Char.isXML11NCNameStart(c2)) {
            if (n <= 1) return false;
            if (!XML11Char.isXML11NameHighSurrogate(c2)) return false;
            c = string.charAt(1);
            if (!XMLChar.isLowSurrogate(c)) return false;
            if (!XML11Char.isXML11NCNameStart(XMLChar.supplemental(c2, c))) {
                return false;
            }
            n2 = 2;
        }
        while (n2 < n) {
            c2 = string.charAt(n2);
            if (!XML11Char.isXML11NCName(c2)) {
                if (++n2 >= n) return false;
                if (!XML11Char.isXML11NameHighSurrogate(c2)) return false;
                c = string.charAt(n2);
                if (!XMLChar.isLowSurrogate(c)) return false;
                if (!XML11Char.isXML11NCName(XMLChar.supplemental(c2, c))) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isXML11ValidNmtoken(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XML11Char.isXML11Name(c)) {
                if (++n2 < n && XML11Char.isXML11NameHighSurrogate(c)) {
                    char c2 = string.charAt(n2);
                    if (!XMLChar.isLowSurrogate(c2) || !XML11Char.isXML11Name(XMLChar.supplemental(c, c2))) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    static {
        int n;
        int n2;
        int n4;
        int n5;
        XML11CHARS = new byte[65536];
        int[] nArray = new int[]{33, 126, 160, 8231, 8233, 55295, 57344, 65533};
        int[] nArray2 = new int[]{9, 10, 13, 32, 133, 8232};
        int[] nArray3 = new int[]{1, 8, 11, 12, 14, 31, 127, 132, 134, 159};
        int[] nArray4 = new int[]{58, 58, 65, 90, 95, 95, 97, 122, 192, 214, 216, 246, 248, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 64975, 65008, 65533};
        int[] nArray5 = new int[]{45, 45, 46, 46, 48, 57, 183, 183, 768, 879, 8255, 8256};
        int[] nArray6 = new int[]{60, 38, 10, 13, 93};
        int n6 = 0;
        while (n6 < nArray.length) {
            n5 = nArray[n6];
            while (n5 <= nArray[n6 + 1]) {
                int n7 = n5++;
                XML11CHARS[n7] = (byte)(XML11CHARS[n7] | 0x21);
            }
            n6 += 2;
        }
        n5 = 0;
        while (n5 < nArray2.length) {
            int n8 = nArray2[n5];
            XML11CHARS[n8] = (byte)(XML11CHARS[n8] | 0x23);
            ++n5;
        }
        int n9 = 0;
        while (n9 < nArray3.length) {
            n4 = nArray3[n9];
            while (n4 <= nArray3[n9 + 1]) {
                int n10 = n4++;
                XML11CHARS[n10] = (byte)(XML11CHARS[n10] | 0x11);
            }
            n9 += 2;
        }
        n4 = 0;
        while (n4 < nArray4.length) {
            n2 = nArray4[n4];
            while (n2 <= nArray4[n4 + 1]) {
                int n11 = n2++;
                XML11CHARS[n11] = (byte)(XML11CHARS[n11] | 0xCC);
            }
            n4 += 2;
        }
        n2 = 0;
        while (n2 < nArray5.length) {
            n = nArray5[n2];
            while (n <= nArray5[n2 + 1]) {
                int n12 = n++;
                XML11CHARS[n12] = (byte)(XML11CHARS[n12] | 0x88);
            }
            n2 += 2;
        }
        XML11CHARS[58] = (byte)(XML11CHARS[58] & 0xFFFFFF3F);
        n = 0;
        while (n < nArray6.length) {
            int n13 = nArray6[n];
            XML11CHARS[n13] = (byte)(XML11CHARS[n13] & 0xFFFFFFDF);
            ++n;
        }
    }
}

