/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xinclude;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XIncludeTextReader {
    private Reader fReader;
    private XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private String fAccept;
    private String fAcceptCharset;
    private String fAcceptLanguage;

    public XIncludeTextReader(XMLInputSource xMLInputSource, XIncludeHandler xIncludeHandler) throws IOException {
        this.fHandler = xIncludeHandler;
        this.fSource = xMLInputSource;
    }

    public void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
    }

    public void setHttpProperties(String string, String string2, String string3) {
        this.fAccept = string;
        this.fAcceptCharset = string2;
        this.fAcceptLanguage = string3;
    }

    protected Reader getReader(XMLInputSource xMLInputSource) throws IOException {
        Object object;
        Object object2;
        String string;
        if (xMLInputSource.getCharacterStream() != null) {
            return xMLInputSource.getCharacterStream();
        }
        InputStream inputStream = null;
        String string2 = xMLInputSource.getEncoding();
        if (string2 == null) {
            string2 = "UTF-8";
        }
        if (xMLInputSource.getByteStream() != null) {
            inputStream = xMLInputSource.getByteStream();
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        } else {
            string = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), false);
            object2 = new URL(string);
            object = ((URL)object2).openConnection();
            if (object instanceof HttpURLConnection) {
                if (this.fAccept != null && this.fAccept.length() > 0) {
                    ((URLConnection)object).setRequestProperty("Accept", this.fAccept);
                }
                if (this.fAcceptCharset != null && this.fAcceptCharset.length() > 0) {
                    ((URLConnection)object).setRequestProperty("Accept-Charset", this.fAcceptCharset);
                }
                if (this.fAcceptLanguage != null && this.fAcceptLanguage.length() > 0) {
                    ((URLConnection)object).setRequestProperty("Accept-Language", this.fAcceptLanguage);
                }
            }
            inputStream = new BufferedInputStream(((URLConnection)object).getInputStream());
            String string3 = ((URLConnection)object).getContentType();
            int n = string3 != null ? string3.indexOf(59) : -1;
            String string4 = null;
            String string5 = null;
            if (n != -1) {
                string4 = string3.substring(0, n).trim();
                string5 = string3.substring(n + 1).trim();
                if (string5.startsWith("charset=")) {
                    if ((string5 = string5.substring(8).trim()).charAt(0) == '\"' && string5.charAt(string5.length() - 1) == '\"' || string5.charAt(0) == '\'' && string5.charAt(string5.length() - 1) == '\'') {
                        string5 = string5.substring(1, string5.length() - 1);
                    }
                } else {
                    string5 = null;
                }
            } else {
                string4 = string3.trim();
            }
            String string6 = null;
            if (string4.equals("text/xml")) {
                string6 = string5 != null ? string5 : "US-ASCII";
            } else if (string4.equals("application/xml")) {
                string6 = string5 != null ? string5 : this.getEncodingName(inputStream);
            } else if (string4.endsWith("+xml")) {
                string6 = this.getEncodingName(inputStream);
            }
            if (string6 != null) {
                string2 = string6;
            }
        }
        string2 = string2.toUpperCase(Locale.ENGLISH);
        this.consumeBOM(inputStream, string2);
        if (string2.equals("UTF-8")) {
            return new UTF8Reader(inputStream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        if (string2.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        string = EncodingMap.getIANA2JavaMapping(string2);
        if (string == null) {
            object2 = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            object = this.fErrorReporter.getLocale();
            throw new IOException(object2.formatMessage((Locale)object, "EncodingDeclInvalid", new Object[]{string2}));
        }
        return new InputStreamReader(inputStream, string);
    }

    protected String getEncodingName(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        String string = null;
        inputStream.mark(4);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        if (n == 4) {
            string = this.getEncodingName(byArray);
        }
        return string;
    }

    protected void consumeBOM(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[3];
        int n = 0;
        inputStream.mark(3);
        if (string.equals("UTF-8")) {
            n = inputStream.read(byArray, 0, 3);
            if (n == 3) {
                int n2 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                int n5 = byArray[2] & 0xFF;
                if (n2 != 239 || n4 != 187 || n5 != 191) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string.startsWith("UTF-16")) {
            n = inputStream.read(byArray, 0, 2);
            if (n == 2) {
                int n6 = byArray[0] & 0xFF;
                int n7 = byArray[1] & 0xFF;
                if (!(n6 == 254 && n7 == 255 || n6 == 255 && n7 == 254)) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        }
    }

    protected String getEncodingName(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        if (n == 254 && n2 == 255) {
            return "UTF-16BE";
        }
        if (n == 255 && n2 == 254) {
            return "UTF-16LE";
        }
        int n4 = byArray[2] & 0xFF;
        if (n == 239 && n2 == 187 && n4 == 191) {
            return "UTF-8";
        }
        int n5 = byArray[3] & 0xFF;
        if (n == 0 && n2 == 0 && n4 == 0 && n5 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (n == 60 && n2 == 0 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n == 0 && n2 == 0 && n4 == 60 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n == 0 && n2 == 60 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n == 0 && n2 == 60 && n4 == 0 && n5 == 63) {
            return "UTF-16BE";
        }
        if (n == 60 && n2 == 0 && n4 == 63 && n5 == 0) {
            return "UTF-16LE";
        }
        if (n == 76 && n2 == 111 && n4 == 167 && n5 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        int n;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        this.fReader = this.getReader(this.fSource);
        while ((n = this.fReader.read()) != -1) {
            if (this.isValid(n)) {
                xMLStringBuffer.append((char)n);
                continue;
            }
            if (XMLChar.isHighSurrogate(n)) {
                int n2 = this.fReader.read();
                if (XMLChar.isLowSurrogate(n2)) {
                    int n4 = XMLChar.supplemental((char)n, (char)n2);
                    if (!this.isValid(n4)) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n4, 16)}, (short)2);
                        continue;
                    }
                    xMLStringBuffer.append((char)n);
                    xMLStringBuffer.append((char)n2);
                    continue;
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n, 16)}, (short)2);
                continue;
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n, 16)}, (short)2);
        }
        if (this.fHandler != null && xMLStringBuffer.length > 0) {
            this.fHandler.characters(xMLStringBuffer, this.fHandler.modifyAugmentations(null, true));
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    protected boolean isValid(int n) {
        return XMLChar.isValid(n);
    }
}

